import logging

from cars.core.daemons import CarsharingDaemon
from ..core.refuel_photo_manager import RefuelPhotoManager


LOGGER = logging.getLogger(__name__)


class RefuelPhotoProcessorDaemon(CarsharingDaemon):

    tick_interval = '*/15 * * * *'  # every hour

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self._refuel_photo_manager = RefuelPhotoManager.from_settings()

    def get_distributed_lock_relative_path(self):
        return 'carsharing/locks/refuel_photo_processor.lock'

    def get_solomon_sensor_prefix(self):
        return 'carsharing.refuel_photo_processor'

    def get_solomon_service(self):
        return 'carsharing'

    def _do_tick(self):
        LOGGER.info('creating refuel recognition tasks')
        self._refuel_photo_manager.create_refuel_recognition_task_suite()
        LOGGER.info('sending tasks to toloka')
        self._refuel_photo_manager.run_refuel_recognition_toloka()


class RefuelReporterDaemon(CarsharingDaemon):

    tick_interval = '*/30 * * * *'  # every half an hour

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self._refuel_photo_manager = RefuelPhotoManager.from_settings()

    def get_distributed_lock_relative_path(self):
        return 'carsharing/locks/refuel_reporter.lock'

    def get_solomon_sensor_prefix(self):
        return 'carsharing.refuel_reporter'

    def get_solomon_service(self):
        return 'carsharing'

    def _do_tick(self):
        LOGGER.info('start making reports')
        self._refuel_photo_manager.make_necessary_reports()

        LOGGER.info('start sending reports')
        self._refuel_photo_manager.send_missed_reports()
