# Generated by Django 2.0.3 on 2018-07-02 17:21

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('carsharing', '0050_car_update_timestamp'),
    ]

    operations = [
        migrations.CreateModel(
            name='RefuelRecognitionTask',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('toloka_task_id', models.IntegerField(null=True)),
                ('car', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                          related_name='refuel_recognition_tasks', to='carsharing.Car')),
                ('photo', models.OneToOneField(on_delete=django.db.models.deletion.PROTECT, to='carsharing.CarsharingTagPhoto')),
            ],
            options={
                'db_table': 'refuel_recognition_task',
            },
        ),
        migrations.CreateModel(
            name='RefuelRecognitionTaskSuite',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('last_refuel_timestamp', models.IntegerField()),
                ('toloka_task_suite_id', models.IntegerField(null=True)),
                ('status', models.CharField(choices=[('new', 'NEW'), ('finished', 'FINISHED'),
                                                     ('reported', 'REPORTED'), ('failed', 'FAILED')], default='new', max_length=8)),
            ],
            options={
                'db_table': 'refuel_recognition_task_suite',
            },
        ),
        migrations.AddField(
            model_name='refuelrecognitiontask',
            name='task_suite',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE,
                                    related_name='tasks', to='refuel.RefuelRecognitionTaskSuite'),
        ),
        migrations.AddField(
            model_name='refuelrecognitiontask',
            name='user',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE,
                                    related_name='refuel_recognition_tasks', to=settings.AUTH_USER_MODEL),
        ),
    ]
