import enum
import uuid

from django.db import models

from cars.users.models.user import User
from cars.carsharing.models.car import Car
from cars.carsharing.models.car_tag_photo import CarsharingTagPhoto


class RefuelRecognitionTaskSuite(models.Model):

    class Status(enum.Enum):
        NEW = 'new'
        FINISHED = 'finished'
        REPORTED = 'reported'
        FAILED = 'failed'

    id = models.UUIDField(default=uuid.uuid4, primary_key=True)
    created_at = models.DateTimeField(auto_now_add=True, null=False)
    last_refuel_datetime = models.DateTimeField(null=True)
    toloka_task_suite_id = models.CharField(
        max_length=40,
        null=True,
    )

    status = models.CharField(
        max_length=8,
        choices=[(x.value, x.name) for x in Status],
        default=Status.NEW.value,
    )

    class Meta:
        db_table = 'refuel_recognition_task_suite'


class RefuelRecognitionTask(models.Model):

    id = models.UUIDField(default=uuid.uuid4, primary_key=True)

    toloka_task_id = models.CharField(
        max_length=40,
        null=True,
    )

    user = models.ForeignKey(
        User,
        related_name='refuel_recognition_tasks',
        on_delete=models.CASCADE,
        null=True,
    )

    car = models.ForeignKey(
        Car,
        related_name='refuel_recognition_tasks',
        on_delete=models.CASCADE,
    )

    photo = models.OneToOneField(
        CarsharingTagPhoto,
        related_name='refuel_recognition_task',
        on_delete=models.PROTECT,
        null=False
    )

    task_suite = models.ForeignKey(
        RefuelRecognitionTaskSuite,
        related_name='tasks',
        on_delete=models.CASCADE,
        null=True,
    )

    tag_history_action = models.CharField(
        max_length=20,
        null=True,
    )

    class Meta:
        db_table = 'refuel_recognition_task'
