import enum
import uuid

from django.db import models

from cars.users.models.user import User
from cars.carsharing.models.car import Car
from cars.carsharing.models.car_tag_photo import CarsharingTagPhoto


class RefuelReport(models.Model):

    id = models.UUIDField(default=uuid.uuid4, primary_key=True)

    from_date = models.DateTimeField(null=False)
    to_date = models.DateTimeField(null=False)
    version = models.IntegerField()

    filename = models.CharField(max_length=256, null=True)
    mds_key = models.CharField(max_length=256, null=True)
    created_at = models.DateTimeField(auto_now_add=True, null=False)
    email_sent_at = models.DateTimeField(null=True)

    class Meta:
        db_table = 'refuel_report'
        unique_together = ('from_date', 'to_date', 'version')
