import enum

from django.db import models


class RefuelTagsAdditionalInfoTimestamp(models.Model):

    class Type(enum.Enum):
        GEO = 'geo'
        DURATION = 'duration'

    type = models.CharField(
        max_length=8,
        choices=[(x.value, x.name) for x in Type],
        primary_key=True,
    )
    timestamp = models.IntegerField(default=0)

    class Meta:
        db_table = 'refuel_tags_additional_info_timestamp'
