from rest_framework.serializers import ModelSerializer, SerializerMethodField

from cars.carsharing.models import Car, CarLocation


class CarLocationSerializer(ModelSerializer):

    class Meta:
        model = CarLocation
        fields = [
            'lat',
            'lon',
        ]


class CarSerializer(ModelSerializer):

    location = CarLocationSerializer()
    fuel_level = SerializerMethodField()
    fuel_type = SerializerMethodField()

    class Meta:
        model = Car
        fields = [
            'id',
            'number',
            'location',
            'model',
            'status',
            'fuel_level',
            'fuel_type',
        ]

    def get_fuel_level(self, obj):
        return obj.telematics_state.fuel_level

    def get_fuel_type(self, obj):
        return obj.model.fuel_type
