from django.conf.urls import url

from . import views


app_name = 'refuel'
urlpatterns = [
    url(r'^cars/$', views.CarListView.as_view(), name='car-list'),
    url(r'^cars/(?P<car_id>[\w-]+)/$', views.CarDetailsView.as_view(), name='car-details'),
    url(
        r'^cars/(?P<car_id>[\w-]+)/commands/blink/$',
        views.CarBlinkCommandView.as_view(),
        name='car-blink',
    ),
    url(
        r'^cars/(?P<car_id>[\w-]+)/commands/open/$',
        views.OpenCarCommandView.as_view(),
        name='car-command-open',
    ),
    url(
        r'^cars/(?P<car_id>[\w-]+)/commands/close/$',
        views.CloseCarCommandView.as_view(),
        name='car-command-close',
    ),
    url(
        r'^cars/(?P<car_id>[\w-]+)/status/available/$',
        views.MoveToAvailableCarStatusView.as_view(),
        name='car-status-available',
    ),
    url(
        r'^cars/(?P<car_id>[\w-]+)/status/fueling/$',
        views.MoveToFuelingCarStatusView.as_view(),
        name='car-status-fueling',
    ),
]
