import enum


class BaseChatItem(object):

    class Type(enum.Enum):
        IMAGE = 'image'
        RETRY_ACTION = 'retry_action'
        TEXT = 'text'
        TEXT_BLOCK = 'text_block'

    def __init__(self, *args, when=None, **kwargs):
        super().__init__(*args, **kwargs)
        self.when = when

    def get_type(self):
        raise NotImplementedError


class ImageChatItem(BaseChatItem):

    def __init__(self, *args, url, on_tap=None, **kwargs):
        super().__init__(*args, **kwargs)
        self.url = url
        self.on_tap = on_tap

    def get_type(self):
        return self.Type.IMAGE


class RetryActionChatItem(BaseChatItem):

    def get_type(self):
        return self.Type.RETRY_ACTION


class TextChatItem(BaseChatItem):

    def __init__(self, *args, message, on_tap=None, **kwargs):
        super().__init__(*args, **kwargs)
        self.message = message
        self.on_tap = on_tap

    def get_type(self):
        return self.Type.TEXT


class TextBlockChatItem(BaseChatItem):

    def __init__(self, *args, messages, **kwargs):
        super().__init__(*args, **kwargs)
        self.messages = messages

    def get_type(self):
        return self.Type.TEXT_BLOCK
