from cars.core.daemons import CarsharingDaemon
from ..core.taxi_cashback import RidesHelper


class BonusUpdaterDaemon(CarsharingDaemon):

    tick_interval = '*/15 * * * *'

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self._rides_helper = RidesHelper()

    def get_solomon_sensor_prefix(self):
        return 'registration.bonus_updater'

    def get_solomon_service(self):
        return 'registration'

    def get_distributed_lock_relative_path(self):
        return 'registration/locks/cashback_bonus_updater.lock'

    def _do_tick(self):
        self._rides_helper.update_ride_records()
