from cars.core.daemons import CarsharingDaemon
from ..core.taxi_cashback import UsersHelper


class PhonesUploaderDaemon(CarsharingDaemon):

    tick_interval = '*/15 * * * *'

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self._users_helper = UsersHelper()

    def get_solomon_sensor_prefix(self):
        return 'registration.phones_uploader'

    def get_solomon_service(self):
        return 'registration'

    def get_distributed_lock_relative_path(self):
        return 'registration/locks/cashback_phones_uploader.lock'

    def _do_tick(self):
        self._users_helper.update_users_phones_at_yt()
