import cars.settings
from cars.core.daemons import CarsharingDaemon
from ..core.registration_manager import RegistrationManager


class RegistrationRegistrarDaemon(CarsharingDaemon):

    tick_interval = '* * * * * */15'

    def _do_tick(self):
        manager = RegistrationManager.from_settings()
        manager.register_all()

    def get_distributed_lock_relative_path(self):
        return 'registration/locks/registrar.lock'

    def get_solomon_sensor_prefix(self):
        return 'daemons.registrar'

    def get_solomon_service(self):
        return cars.settings.REGISTRATION['solomon']['service']
