import cars.settings
from cars.core.daemons import CarsharingDaemon
from ..core.verification_call_resolver import RegistrationVerificationCallResolver


class RegistrationVerificationCallResolverDaemon(CarsharingDaemon):

    tick_interval = '* * * * * */3'  # every 3 seconds

    def _do_tick(self):
        resolver = RegistrationVerificationCallResolver.from_settings()
        resolver.resolve_all()

    def get_distributed_lock_relative_path(self):
        return 'registration/locks/verification_call_resolver.lock'

    def get_solomon_sensor_prefix(self):
        return 'daemons.verification_call_resolver'

    def get_solomon_service(self):
        return cars.settings.REGISTRATION['solomon']['service']
