# -*- coding: utf-8 -*-
# Generated by Django 1.11.6 on 2017-11-26 21:52
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('registration', '0003_add_registration_chat_message_on_tap'),
    ]

    operations = [
        migrations.CreateModel(
            name='RegistrationVerificationCall',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('session_id', models.CharField(max_length=36, unique=True)),
                ('submitted_at', models.DateTimeField()),
                ('resolved_at', models.DateTimeField(null=True)),
                ('status', models.CharField(choices=[('p', 'INPROGRESS'), ('o', 'OK'), ('u', 'NO_PICK_UP'), ('r', 'NO_RESPONSE'), ('e', 'ERROR')], max_length=1)),
            ],
            options={
                'db_table': 'registration_verification_call',
            },
        ),
        migrations.RemoveIndex(
            model_name='registrationchatactionresult',
            name='registration_chat_action_result_user_suggested_date_idx',
        ),
        migrations.RenameField(
            model_name='registrationchatactionresult',
            old_name='submitted_date',
            new_name='submitted_at',
        ),
        migrations.RenameField(
            model_name='registrationchatactionresult',
            old_name='suggested_date',
            new_name='suggested_at',
        ),
        migrations.AddField(
            model_name='registrationchatactionresult',
            name='completed_at',
            field=models.DateTimeField(null=True),
        ),
        migrations.AddField(
            model_name='registrationchatactionresult',
            name='status',
            field=models.CharField(choices=[('n', 'NEW'), ('p', 'INPROGRESS'), ('c', 'COMPLETE')], default='n', max_length=1),
        ),
        migrations.AddIndex(
            model_name='registrationchatactionresult',
            index=models.Index(fields=['user', 'suggested_at'], name='registration_chat_action_result_user_suggested_at_idx'),
        ),
        migrations.AddField(
            model_name='registrationverificationcall',
            name='chat_action_result',
            field=models.ForeignKey(db_index=False, on_delete=django.db.models.deletion.CASCADE, to='registration.RegistrationChatActionResult'),
        ),
        migrations.AddField(
            model_name='registrationverificationcall',
            name='user',
            field=models.ForeignKey(db_index=False, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddIndex(
            model_name='registrationverificationcall',
            index=models.Index(fields=['user'], name='registration_verification_call_user_idx'),
        ),
        migrations.AddIndex(
            model_name='registrationverificationcall',
            index=models.Index(fields=['chat_action_result'], name='registration_verification_call_chat_action_result_idx'),
        ),
        migrations.AddIndex(
            model_name='registrationverificationcall',
            index=models.Index(fields=['session_id'], name='registration_verification_call_session_id_idx'),
        ),
        migrations.AddIndex(
            model_name='registrationverificationcall',
            index=models.Index(fields=['status'], name='registration_verification_call_status_idx'),
        ),
    ]
