from django.contrib.postgres.fields import JSONField
from django.db import models

from cars.users.models import User


class RegistrationChatActionQueue(models.Model):
    user = models.ForeignKey(
        User,
        db_index=False,
        on_delete=models.CASCADE,
    )
    chat_action_id = models.CharField(max_length=32)
    context = JSONField(null=True)
    enqueued_at = models.DateTimeField()
    dequeued_at = models.DateTimeField(null=True)

    class Meta:
        db_table = 'registration_chat_action_queue'
        indexes = [
            models.Index(
                fields=['user'],
                name='registration_chat_action_queue_user_idx',
            ),
        ]
