import enum

from django.contrib.postgres.fields import JSONField
from django.db import models

from cars.users.models import User


class RegistrationChatActionResult(models.Model):

    class Status(enum.Enum):
        NEW = 'n'
        INPROGRESS = 'p'
        COMPLETE = 'c'

    class Type(enum.Enum):
        CALL_VERIFY = 'call_verify'
        CREDIT_CARD = 'credit_card'
        DRIVER_LICENSE = 'license'
        DRIVER_LICENSE_BACK = 'license_back'
        DRIVER_LICENSE_FRONT = 'license_front'
        ENTER_APP = 'enter_app'
        OK = 'ok'
        PASSPORT = 'passport'
        PASSPORT_BIOGRAPHICAL = 'passport_bio'
        PASSPORT_REGISTRATION = 'passport_reg'
        PASSPORT_SELFIE = 'passport_selfie'

    chat_action_id = models.CharField(max_length=32)
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    suggested_at = models.DateTimeField()
    submitted_at = models.DateTimeField(null=True)
    completed_at = models.DateTimeField(null=True)
    status = models.CharField(
        max_length=1,
        choices=[(x.value, x.name) for x in Status],
        default=Status.NEW.value,
    )
    type = models.CharField(max_length=16, choices=[(x.value, x.name) for x in Type])
    context = JSONField(null=True)
    data = JSONField(null=True)

    class Meta:
        db_table = 'registration_chat_action_result'
        indexes = [
            models.Index(
                fields=['user', 'suggested_at'],
                name='registration_chat_action_result_user_suggested_at_idx',
            ),
        ]

    def is_status_complete(self):
        return self.status == self.Status.COMPLETE.value

    def is_status_inprogress(self):
        return self.status == self.Status.INPROGRESS.value

    def is_status_new(self):
        return self.status == self.Status.NEW.value
