import enum

from django.contrib.postgres.fields import JSONField
from django.db import models

from cars.users.models import User


class RegistrationChatMessage(models.Model):

    class Source(enum.Enum):
        SYSTEM = 'system'
        USER = 'user'

    class Type(enum.Enum):
        CARD = 'card'
        IMAGE = 'image'
        TEXT = 'text'
        USER_DOCUMENT = 'userdoc'
        USER_DOCUMENTS = 'userdocs'

    user = models.ForeignKey(User, on_delete=models.CASCADE)
    date = models.DateTimeField()
    chat_action_id = models.CharField(max_length=32, null=True, blank=True)
    source = models.CharField(max_length=8, choices=[(x.value, x.name) for x in Source])
    type = models.CharField(max_length=8, choices=[(x.value, x.name) for x in Type])
    content = JSONField()
    on_tap = JSONField(null=True, blank=True)
    is_visible = models.NullBooleanField(default=True)

    class Meta:
        db_table = 'registration_chat_message'
        indexes = [
            models.Index(fields=['user', 'date'], name='registration_chat_message_user_date_idx'),
        ]

    def __str__(self):
        return '[{}] {}: {}'.format(self.date.isoformat(), self.Type(self.type), self.content)
