from django.db import models

from cars.users.models import User


class RegistrationTaxiRide(models.Model):

    id = models.CharField(primary_key=True, max_length=32)
    user = models.ForeignKey(
        User,
        related_name='registration_taxi_rides',
        on_delete=models.CASCADE,
    )
    ride_utc_time = models.DateTimeField()
    cost = models.DecimalField(max_digits=9, decimal_places=2)

    class Meta:
        db_table = 'registration_taxi_ride'
