import enum

from django.db import models

from cars.users.models import User
from .chat_action_result import RegistrationChatActionResult


class RegistrationVerificationCall(models.Model):

    class Status(enum.Enum):
        INPROGRESS = 'p'
        OK = 'o'
        NO_PICK_UP = 'u'
        NO_RESPONSE = 'r'
        ERROR = 'e'

    user = models.ForeignKey(
        User,
        db_index=False,
        on_delete=models.CASCADE,
    )
    chat_action_result = models.ForeignKey(
        RegistrationChatActionResult,
        db_index=False,
        on_delete=models.CASCADE,
    )
    session_id = models.CharField(max_length=36, unique=False, null=True, db_index=False)
    submitted_at = models.DateTimeField()
    resolved_at = models.DateTimeField(null=True)
    status = models.CharField(
        max_length=1,
        choices=[(x.value, x.name) for x in Status],
    )

    class Meta:
        db_table = 'registration_verification_call'
        indexes = [
            models.Index(
                fields=['user'],
                name='registration_verification_call_user_idx',
            ),
            models.Index(
                fields=['chat_action_result'],
                name='registration_verification_call_chat_action_result_idx',
            ),
            models.Index(
                fields=['session_id'],
                name='registration_verification_call_session_id_idx',
            ),
            models.Index(
                fields=['status'],
                name='registration_verification_call_status_idx',
            ),
        ]

    def __str__(self):
        return 'Verification call from {}: {}'.format(
            self.submitted_at.isoformat(),
            self.Status(self.status).name,
        )
