import datetime

import pytz
from rest_framework import serializers

from cars.django.serializers import BaseSerializer, TimestampField
from ..models.chat_message import RegistrationChatMessage


class ChatViewArgumentsSerializer(BaseSerializer):

    since = TimestampField(default=pytz.UTC.localize(datetime.datetime.min))


class ChatActionArgumentsSerializer(BaseSerializer):

    id = serializers.CharField()
    data = serializers.DictField()


class RegistrationChatActionSerializer(BaseSerializer):

    id = serializers.CharField()
    type = serializers.SerializerMethodField()
    params = serializers.SerializerMethodField()

    def get_type(self, obj):
        return obj.get_type().value

    def get_params(self, obj):
        return obj.get_params()


class RegistrationChatMessageEventSerializer(BaseSerializer):

    type = serializers.CharField()
    content = serializers.JSONField()


class RegistrationChatMessageSerializer(serializers.ModelSerializer):

    date = TimestampField()
    on_tap = RegistrationChatMessageEventSerializer()

    class Meta:
        model = RegistrationChatMessage
        fields = [
            'id',
            'date',
            'chat_action_id',
            'source',
            'type',
            'on_tap',
            'content',
        ]

    def to_representation(self, obj):
        data = super().to_representation(obj)
        self._remove_optional_field(data=data, field='on_tap')
        return data

    def _remove_optional_field(self, data, field):
        if data[field] is None:
            data.pop(field)


class ChatStateSerializer(BaseSerializer):

    action = RegistrationChatActionSerializer()
    new_messages = RegistrationChatMessageSerializer(many=True)
