from cars.core.daemons import CarsharingDaemon
from ..core.assignment import AssignmentManager


class ResultsFetcherDaemon(CarsharingDaemon):

    tick_interval = '* * * * * */15'

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self._manager = AssignmentManager.from_settings()

    def get_distributed_lock_relative_path(self):
        return 'yang/locks/yang_results_fetcher.lock'

    def get_solomon_sensor_prefix(self):
        return 'yang.results_fetcher'

    def get_solomon_service(self):
        return 'yang'

    def _do_tick(self):
        self._manager.fetch_verification_results()
