import datetime
import uuid

import pytz
from factory import LazyAttribute, SubFactory
from factory.django import DjangoModelFactory
from factory.fuzzy import FuzzyDateTime, FuzzyText

from cars.users.factories.user_documents import UserDocumentPhotoFactory
from ..models.assignment import YangAssignment


class YangAssignmentFactory(DjangoModelFactory):

    class Meta:
        model = YangAssignment

    passport_biographical = SubFactory(UserDocumentPhotoFactory)
    passport_registration = SubFactory(UserDocumentPhotoFactory)
    passport_selfie = SubFactory(UserDocumentPhotoFactory)
    license_front = SubFactory(UserDocumentPhotoFactory)
    license_back = SubFactory(UserDocumentPhotoFactory)

    is_fraud = YangAssignment.Status.NOT_FRAUD.value

    comments = LazyAttribute(
        lambda obj: [FuzzyText().fuzz() for _ in range(3)],
    )
    workers = LazyAttribute(
        lambda obj: [FuzzyText().fuzz() for _ in range(3)],
    )
    assignment_ids = LazyAttribute(
        lambda obj: [uuid.uuid4() for _ in range(3)],
    )

    created_at = FuzzyDateTime(datetime.datetime(2017, 1, 1, tzinfo=pytz.UTC))
    processed_at = FuzzyDateTime(datetime.datetime(2017, 1, 1, tzinfo=pytz.UTC))
    ingested_at = FuzzyDateTime(datetime.datetime(2017, 1, 1, tzinfo=pytz.UTC))
