from rest_framework.serializers import ModelSerializer, SerializerMethodField

from ..models import YangAssignment


class YangFillingHistorySerializer(ModelSerializer):

    documents_entered_text_data = SerializerMethodField()

    class Meta:
        model = YangAssignment
        fields = [
            'id',
            'is_fraud',
            'workers',
            'assignment_ids',
            'documents_entered_text_data',
            'fraud_reasons',
            'history'
        ]

    def get_documents_entered_text_data(self, obj):
        raw_text_data = []

        has_at_mark = obj.license_back.user.has_at_mark
        if has_at_mark is None:
            has_at_mark = False

        for assignment_id, worker_id in zip(obj.assignment_ids or [], obj.workers or []):
            raw_passport_data = self.context['datasync_client'].get_passport_unverified(
                uid=obj.license_back.user.uid,
                key=assignment_id,
            )

            raw_license_data = self.context['datasync_client'].get_license_unverified(
                uid=obj.license_back.user.uid,
                key=assignment_id,
            )

            if raw_license_data is not None:
                raw_license_data['has_at_mark'] = has_at_mark

            raw_text_data.append(
                {
                    'worker_id': worker_id,
                    'assignment_id': assignment_id,
                    'passport_entered': raw_passport_data,
                    'license_entered': raw_license_data,
                }
            )

        return raw_text_data
