from django.shortcuts import get_object_or_404
from rest_framework.response import Response

from cars.users.core.datasync import DataSyncDocumentsClient
from ..models import YangAssignment
from ..serializers import YangFillingHistorySerializer
from .base import RegistrationYangView


class DocumentsFillingHistoryView(RegistrationYangView):
    """
    Get all fillings for secret_id.
    Basically the same as admin endpoint.
    """

    datasync = DataSyncDocumentsClient.from_settings()

    def get_serializer_context(self):
        context = super().get_serializer_context()
        context['datasync_client'] = self.datasync
        return context

    def do_get(self, _, secret_id):
        assignment = get_object_or_404(YangAssignment, id=secret_id)
        response_dict = YangFillingHistorySerializer(
            assignment,
            context=self.get_serializer_context(),
        ).data

        return Response(response_dict)
