import datetime

from cars.request_aggregator.core.request_time_sync_helper import RequestDateSyncHelper
from cars.request_aggregator.models.call_center_common import SyncOrigin


class AudioteleDailyStatSyncHelper(RequestDateSyncHelper):
    @classmethod
    def from_settings(cls):
        return cls(
            stat_sync_origin=SyncOrigin.CC_AUDIOTELE,
            default_since=datetime.date(2018, 10, 14),
        )


class AudioteleCallTrackCollectingSyncHelper(RequestDateSyncHelper):
    @classmethod
    def from_settings(cls):
        return cls(
            stat_sync_origin=SyncOrigin.CC_AUDIOTELE_TRACKS,
            default_since=datetime.date(2018, 11, 4),
        )


class AudioteleCallTrackBindingSyncHelper(RequestDateSyncHelper):
    @classmethod
    def from_settings(cls):
        return cls(
            stat_sync_origin=SyncOrigin.CC_AUDIOTELE_TRACK_BINDINGS,
            default_since=datetime.date(2018, 11, 4),
        )
