import logging

import cars.settings

from cars.request_aggregator.core.request_tags import RequestTagBindingHelper

from cars.request_aggregator.models.audiotele_stats import (
    AudioteleIncomingCallEntry, AudioteleCallDirection, AudioteleCallAction
)
from cars.request_aggregator.models.call_center_common import SyncOrigin
from cars.request_aggregator.models.call_tags import RequestOriginType


LOGGER = logging.getLogger(__name__)


class AudioteleIncomingTagBindingHelper(RequestTagBindingHelper):
    @classmethod
    def from_settings(cls):
        return cls(
            stat_sync_origin=SyncOrigin.CC_AUDIOTELE_INCOMING_TAGS_BINDING,
            request_origin=RequestOriginType.AUDIOTELE_INCOMING
        )

    def _get_entry_to_process_values(self, since, until):
        entries_to_process = (
            AudioteleIncomingCallEntry.objects
            .using(cars.settings.DB_RO_ID)
            .select_related('staff_entry_binding')
            .filter(
                time_enter__range=(since, until),
                direction=AudioteleCallDirection.INCOMING.value,
                action=AudioteleCallAction.FINISH.value,
                staff_entry_binding__isnull=False,
                is_answered=True,
            )
            .values('id', 'phone', 'staff_entry_binding__user_id')
        )
        return entries_to_process


class AudioteleOutgoingTagBindingHelper(RequestTagBindingHelper):
    @classmethod
    def from_settings(cls):
        return cls(
            stat_sync_origin=SyncOrigin.CC_AUDIOTELE_OUTGOING_TAGS_BINDING,
            request_origin=RequestOriginType.AUDIOTELE_OUTGOING
        )

    def _get_entry_to_process_values(self, since, until):
        entries_to_process = (
            AudioteleIncomingCallEntry.objects
            .using(cars.settings.DB_RO_ID)
            .select_related('staff_entry_binding')
            .filter(
                time_enter__range=(since, until),
                direction=AudioteleCallDirection.OUTGOING.value,
                action=AudioteleCallAction.FINISH.value,
                staff_entry_binding__isnull=False,
                is_answered=True,
            )
            .values('id', 'phone', 'staff_entry_binding__user_id')
        )
        return entries_to_process
