import datetime

from django.db.models import Min

from cars.core.util import datetime_helper
from cars.callcenter.models import CallAssignment

from cars.request_aggregator.core.request_time_sync_helper import RequestTimeSyncHelper
from cars.request_aggregator.models.call_center_common import SyncOrigin


class TelephonyAssignmentRequestTimeSyncHelper(RequestTimeSyncHelper):
    # do not collect calls started earlier than the value
    MAX_CALL_START_DELAY = datetime.timedelta(minutes=10)

    @classmethod
    def from_settings(cls):
        # collect actual time range overlapped by 2 seconds with the previous one, but not more than 45 minutes
        # previous range is derived from the longest call
        return cls(
            SyncOrigin.SERVICE_CC_INTERNAL_ASSIGNMENT_UPDATE,
            default_since=datetime_helper.utc_now() - cls.MAX_CALL_START_DELAY,
            max_time_span=datetime.timedelta(minutes=45),
            request_lag=datetime.timedelta(minutes=0),
            request_overlap=datetime.timedelta(seconds=2),
        )

    def _update_last_data_sync_time(self, sync_entry, until):
        entries_stats = CallAssignment.objects.aggregate(Min('added_at'))

        if entries_stats['added_at__min'] is not None:
            until = max(entries_stats['added_at__min'], datetime_helper.utc_now() - self.max_time_span)

        super()._update_last_data_sync_time(sync_entry, until)
