import collections
import logging

LOGGER = logging.getLogger(__name__)


class RegisteringHelperBase(object):
    @classmethod
    def from_settings(cls):
        return cls()

    def update_data(self, raw_entries, all_entries_stat):
        entries_stat = collections.Counter()

        entries = self._process_entries(raw_entries, entries_stat)
        self._apply_entries(entries)

        LOGGER.info('processed entries: {}'.format(entries_stat))
        all_entries_stat.update(entries_stat)

        return entries_stat

    def _process_entries(self, raw_entries, entries_stat):
        entries = (
            self._process_entry(entry) for entry in raw_entries
            if self._handle_entry(entry, entries_stat)
        )
        return entries

    def _handle_entry(self, raw_entry, entries_stat):
        entries_stat[raw_entry.verb] += 1
        return True

    def _process_entry(self, raw_entry):
        raise NotImplementedError

    def _apply_entries(self, entries):
        raise NotImplementedError
