import json
import logging

from cars.request_aggregator.core.data_exporting_helper import DataExportingSyncHelper, DataExportingHelper
from cars.request_aggregator.models.internal_cc_stats import CallCenterEntry

LOGGER = logging.getLogger(__name__)


class InternalCCIncomingDataExportingSyncHelper(DataExportingSyncHelper):
    entry_model_cls = CallCenterEntry


class InternalCCIncomingDataExportingHelper(DataExportingHelper):
    _sync_helper_cls = InternalCCIncomingDataExportingSyncHelper

    def _make_export_entry(self, entry):
        data = {
            'id': str(entry.id),
            'agent': entry.agent,
            'callId': entry.call_id,
            'phone': self.get_original_phone(entry),
            'queue': entry.queue_name,
            'timeId': self.time_to_repr(entry.time_id),
            'verb': entry.verb,
            'agentUsername': self.get_agent_username(entry),
            'metaInfo': json.dumps(entry.meta_info) if entry.meta_info else None,
        }
        return data
