import datetime

from cars.core.util import datetime_helper

from cars.request_aggregator.core.request_time_sync_helper import RequestTimeSyncHelper
from cars.request_aggregator.models.call_center_common import SyncOrigin


class IncomingTelephonyRequestTimeSyncHelper(RequestTimeSyncHelper):
    @classmethod
    def from_settings(cls):
        # collect actual time range overlapped by 2 seconds with the previous one, but not more than 6 hours
        return cls(
            SyncOrigin.CC_INTERNAL_INCOMING_ENTRIES,
            default_since=datetime_helper.utc_localize(datetime.datetime(2018, 2, 14)),
            max_time_span=datetime.timedelta(hours=6),
            request_lag=datetime.timedelta(seconds=0),
            request_overlap=datetime.timedelta(seconds=2),
        )
