import cars.settings

from cars.request_aggregator.core.request_tags import RequestTagBindingHelper

from cars.request_aggregator.models.internal_cc_stats import (
    OutgoingCallCenterEntry, CallCenterAltayOutgoingEntry, InternalCCAltayStatus
)
from cars.request_aggregator.models.call_center_common import SyncOrigin
from cars.request_aggregator.models.call_tags import RequestOriginType


# deprecated
class InternalCCOutgoingTagBindingHelper(RequestTagBindingHelper):
    @classmethod
    def from_settings(cls):
        return cls(
            stat_sync_origin=SyncOrigin.CC_INTERNAL_OUTGOING_TAGS_BINDING,
            request_origin=RequestOriginType.CARSHARING_OUTGOING
        )

    def _get_entry_to_process_values(self, since, until):
        entries_to_process = (
            OutgoingCallCenterEntry.objects
            .using(cars.settings.DB_RO_ID)
            .select_related('staff_entry_binding')
            .filter(
                time_enter__range=(since, until),
                staff_entry_binding__isnull=False,
                time_connect__isnull=False,
            )
            .values('id', 'phone', 'staff_entry_binding__user_id')
        )
        return entries_to_process


class InternalCCAltayOutgoingTagBindingHelper(RequestTagBindingHelper):
    @classmethod
    def from_settings(cls):
        return cls(
            stat_sync_origin=SyncOrigin.CC_INTERNAL_ALTAY_OUTGOING_TAGS_BINDING,
            request_origin=RequestOriginType.CC_INTERNAL_ALTAY_OUTGOING
        )

    def _get_entry_to_process_values(self, since, until):
        entries_to_process = (
            CallCenterAltayOutgoingEntry.objects
            .using(cars.settings.DB_RO_ID)
            .select_related('staff_entry_binding')
            .filter(
                time_enter__range=(since, until),
                staff_entry_binding__isnull=False,
                time_connect__isnull=False,
                status=InternalCCAltayStatus.SUCCESS.value,
            )
            .values('id', 'phone', 'staff_entry_binding__user_id')
        )
        return entries_to_process
