import json
import logging

from cars.request_aggregator.core.data_exporting_helper import DataExportingSyncHelper, DataExportingHelper
from cars.request_aggregator.models.call_center_common import CallRoutingEntry

LOGGER = logging.getLogger(__name__)


class InternalCCRoutingDataExportingSyncHelper(DataExportingSyncHelper):
    entry_model_cls = CallRoutingEntry


class InternalCCRoutingDataExportingHelper(DataExportingHelper):
    _sync_helper_cls = InternalCCRoutingDataExportingSyncHelper

    def _make_export_entry(self, entry):
        agent = entry.meta_info.get('agent', None) if entry.meta_info else None
        queue_name = entry.meta_info.get('queue_name', None) if entry.meta_info else None

        agent_username = None

        if agent:
            agent_work_phone = self._staff_helper.try_extract_agent_work_phone(agent)

            if agent_work_phone:
                agent_instance = self._staff_helper.get_agent_entry(work_phone=agent_work_phone)

                if agent_instance:
                    agent_username = agent_instance.username

        data = {
            'id': str(entry.id),
            'agent': agent,
            'callId': entry.call_id,
            'phone': self.get_original_phone(entry),
            'queue': queue_name,
            'timeId': self.time_to_repr(entry.time_id),
            'verb': entry.verb,
            'agentUsername': agent_username,
            'metaInfo': json.dumps(entry.meta_info) if entry.meta_info else None,
            'sourceCC': entry.source_cc,
            'targetCC': entry.target_cc,
        }

        return data
