import logging

from cars.core.util import phone_number_helper
from cars.request_aggregator.models.call_center_common import CallRoutingEntry

from ..base.webhook_helper import RegisteringHelperBase

LOGGER = logging.getLogger(__name__)


class IncomingEntryRegisteringHelper(RegisteringHelperBase):
    def _process_entry(self, entry):
        entry_meta_info = {}

        original_phone = entry.phone
        phone = phone_number_helper.normalize_phone_number(original_phone)

        if phone is None:
            entry_meta_info['original_phone'] = original_phone

        processed_entry = CallRoutingEntry(
            time_id=entry.time_id,
            call_id=entry.call_id,
            verb=entry.verb,
            source_cc=entry.source_cc,
            phone=phone,
            meta_info=(entry_meta_info or None),
        )
        return processed_entry

    def _apply_entries(self, entries):
        CallRoutingEntry.objects.bulk_create(entries)


class DistributeEntryRegisteringHelper(RegisteringHelperBase):
    def _handle_entry(self, raw_entry, entries_stat):
        entries_stat[raw_entry.target_cc] += 1
        entries_stat[raw_entry.verb] += 1
        return True

    def _process_entry(self, entry):
        entry_meta_info = {}

        original_phone = entry.phone
        phone = phone_number_helper.normalize_phone_number(original_phone)

        if phone is None:
            entry_meta_info['original_phone'] = original_phone

        entry_fallback = entry.fallback
        if entry_fallback:
            entry_meta_info['entry_fallback'] = entry_fallback

        processed_entry = CallRoutingEntry(
            time_id=entry.time_id,
            call_id=entry.call_id,
            verb=entry.verb,
            source_cc=entry.source_cc,
            target_cc=entry.target_cc,
            phone=phone,
            meta_info=(entry_meta_info or None),
        )
        return processed_entry

    def _apply_entries(self, entries):
        CallRoutingEntry.objects.bulk_create(entries)


class XConnectEntryRegisteringHelper(RegisteringHelperBase):
    def _process_entry(self, entry):
        entry_meta_info = {
            'agent': entry.agent,
            'queue_name': entry.queue,
        }
        processed_entry = CallRoutingEntry(
            time_id=entry.time_id,
            call_id=entry.call_id,
            verb=entry.verb,
            meta_info=entry_meta_info,
        )
        return processed_entry

    def _apply_entries(self, entries):
        CallRoutingEntry.objects.bulk_create(entries)
