import collections
import json
import logging

from .routing.api_helper import RegisterCallApiHelper
from .routing.webhook_helper import (
    IncomingEntryRegisteringHelper, DistributeEntryRegisteringHelper, XConnectEntryRegisteringHelper
)
from .assigning.webhook_helper import AssignmentRegisteringHelper


LOGGER = logging.getLogger(__name__)


class CallRegisteringWebHookHelper(object):
    def __init__(self):
        self._api_helper = RegisterCallApiHelper.from_settings()

        self._incoming_entry_registering_helper = IncomingEntryRegisteringHelper.from_settings()
        self._distribute_entry_registering_helper = DistributeEntryRegisteringHelper.from_settings()
        self._connect_entry_registering_helper = XConnectEntryRegisteringHelper.from_settings()

        self._assignment_registering_helper = AssignmentRegisteringHelper.from_settings()

    @classmethod
    def from_settings(cls):
        return cls()

    def process_data(self, request_data):
        try:
            data = json.loads(request_data) if isinstance(request_data, str) else request_data
            entries = data['DATA'].values()
        except Exception as exc:
            raise Exception('incorrect call registering data format') from exc

        processed_entries = self._api_helper.process_data(entries)
        return processed_entries

    def register_entries(self, processed_entries):
        all_entries_stat = collections.Counter()

        income_entries, routing_entries, assignment_entries = processed_entries

        if income_entries:
            self._incoming_entry_registering_helper.update_data(income_entries, all_entries_stat)

        if routing_entries:
            self._distribute_entry_registering_helper.update_data(routing_entries, all_entries_stat)

        if assignment_entries:
            self._connect_entry_registering_helper.update_data(assignment_entries, all_entries_stat)
            self._assignment_registering_helper.update_data(assignment_entries, all_entries_stat)

        return all_entries_stat
