import logging

from cars.core.history import HistoryManager

from cars.settings import REQUEST_AGGREGATOR

from cars.request_aggregator.models import RequestTagEntryHistory


LOGGER = logging.getLogger(__name__)


class RequestTagsHistoryManager(HistoryManager):
    def __init__(self):
        super().__init__(RequestTagEntryHistory)
        self._default_performer_id = REQUEST_AGGREGATOR['common']['default_performer_id']

    def add_entry(self, new_object_state, operator_id=None, timestamp_override=None):
        operator_id = operator_id or self._default_performer_id
        return super().add_entry(new_object_state, operator_id, timestamp_override)

    def bulk_add_entries(self, new_object_state_collection, operator_id=None, timestamp_override=None):
        history_records = self.prepare_history_records(new_object_state_collection, operator_id, timestamp_override)
        self.bulk_add_prepared_entries(history_records)

    def prepare_history_records(self, new_object_state_collection, operator_id=None, timestamp_override=None):
        operator_id = operator_id or self._default_performer_id

        history_records = [
            self._make_history_record(
                new_object_state, operator_id, HistoryManager.HistoryAction.ADD, timestamp_override
            )
            for new_object_state in new_object_state_collection
        ]

        return history_records

    def bulk_add_prepared_entries(self, history_records):
        try:
            self._history_wrapper_cls.objects.bulk_create(history_records)
        except Exception:
            LOGGER.exception('unable to save history record')
            raise

    def update_entry(self, new_object_state, operator_id=None, timestamp_override=None):
        operator_id = operator_id or self._default_performer_id
        return super().update_entry(new_object_state, operator_id, timestamp_override)

    def remove_entry(self, new_object_state, operator_id=None, timestamp_override=None):
        operator_id = operator_id or self._default_performer_id
        return super().remove_entry(new_object_state, operator_id, timestamp_override)
