import json
import logging

from cars.core.util import datetime_helper

from cars.request_aggregator.core.common_helper import SolomonHelper, YTHelper

from .base import ExportHelperBase


LOGGER = logging.getLogger(__name__)


class SolomonExportHelper(ExportHelperBase):
    def __init__(self, sensor_prefix):
        self._solomon_helper = SolomonHelper(sensor_prefix)

    def export(self, flattened_statistics):
        for sensor, value in flattened_statistics.items():
            self._solomon_helper.report_value(sensor, value)


class YtExportHelper(ExportHelperBase):
    def __init__(self, yt_export_table):
        self._yt_helper = YTHelper(yt_export_table)

    def export(self, flattened_statistics):
        data = [{
            'timestamp': str(datetime_helper.timestamp_now()),
            'datetime': str(datetime_helper.utc_now()),
            'data': flattened_statistics,
        }]
        self._yt_helper.export_data(data)

    def optimize(self):
        self._yt_helper.merge_chunks()


class LogExportHelper(ExportHelperBase):
    def export(self, flattened_statistics):
        statistics_to_dump = json.dumps(flattened_statistics)
        LOGGER.info('reporting statistics: {}'.format(statistics_to_dump))
