import logging

from cars.core.daemons import CarsharingDaemon


LOGGER = logging.getLogger(__name__)


class CollectingDaemonBase(CarsharingDaemon):
    def __init__(self, helper, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self._helper = helper

    def get_distributed_lock_relative_path(self):
        return '{}/locks/{}.lock'.format(self.get_solomon_service(), self.get_daemon_name())

    def get_solomon_sensor_prefix(self):
        return '{}.{}'.format(self.get_solomon_service(), self.get_daemon_name())

    def get_solomon_service(self):
        return 'request_aggregator'

    def get_daemon_name(self):
        raise NotImplementedError

    def _do_tick(self):
        entries_stat = self._helper.update_data()
        self._report_tick_processed_entries_count(entries_stat)

    def _report_tick_processed_entries_count(self, entries_stat):
        for name, value in entries_stat.items():
            full_name = '.'.join((self.get_solomon_sensor_prefix(), name))
            try:
                self.solomon.set_value(full_name, value)
            except Exception as exc:
                LOGGER.exception('error reporting value of sensor "{}"'.format(full_name))
