import logging

from cars.core.daemons import CarsharingDaemon
from cars.core.util import handle_error

from cars.request_aggregator.core import (
    AudioteleIncomingTagBindingHelper,
    AudioteleOutgoingTagBindingHelper,
    InternalCCIncomingGenericTagBindingHelper,
    InternalCCIncomingVipTagBindingHelper,
    InternalCCAltayOutgoingTagBindingHelper,
)

LOGGER = logging.getLogger(__name__)


class RequestTagsBindingDaemon(CarsharingDaemon):

    tick_interval = '*/5 * * * *'  # every 5 minutes

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self._helpers = [
            AudioteleIncomingTagBindingHelper.from_settings(),
            AudioteleOutgoingTagBindingHelper.from_settings(),
            InternalCCIncomingGenericTagBindingHelper.from_settings(),
            InternalCCIncomingVipTagBindingHelper.from_settings(),
            InternalCCAltayOutgoingTagBindingHelper.from_settings(),
        ]

    def get_distributed_lock_relative_path(self):
        return 'request_aggregator/locks/request_tag_binding_daemon.lock'

    def get_solomon_sensor_prefix(self):
        return 'request_aggregator.request_tag_binding_daemon'

    def get_solomon_service(self):
        return 'request_aggregator'

    def _do_tick(self):
        for helper in self._helpers:
            with handle_error(re_raise=False):
                helper.update_tag_bindings()
