# Generated by Django 2.0.3 on 2018-09-17 15:14

from django.db import migrations, models
import django.db.models.deletion
import phonenumber_field.modelfields


class Migration(migrations.Migration):

    dependencies = [
        ('request_aggregator', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Chat2DeskClientEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('related_id', models.IntegerField()),
                ('time_id', models.DateTimeField()),
                ('assigned_phone', phonenumber_field.modelfields.PhoneNumberField(max_length=128, null=True)),
                ('extra_identification_info', models.CharField(blank=True, default='', max_length=255)),
            ],
            options={
                'db_table': 'chat2desk_clients',
            },
        ),
        migrations.CreateModel(
            name='Chat2DeskMessageEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('related_id', models.IntegerField()),
                ('related_request_id', models.IntegerField(null=True)),
                ('time_id', models.DateTimeField()),
                ('text', models.CharField(blank=True, max_length=2048)),
                ('attachment_url', models.URLField(null=True)),
                ('attachment_type', models.CharField(choices=[('audio', 'AUDIO'), ('pdf', 'PDF'), ('photo', 'PHOTO'), ('video', 'VIDEO')], max_length=8, null=True)),
                ('transport', models.CharField(choices=[('telegram', 'TELEGRAM'), ('whatsapp', 'WHATSAPP')], max_length=8)),
                ('entry_type', models.CharField(choices=[('from_client', 'FROM_CLIENT'), ('to_client', 'TO_CLIENT'), ('request_start', 'REQUEST_START'), ('request_end', 'REQUEST_END'), ('autoreply', 'AUTOREPLY'), ('system', 'SYSTEM')], max_length=16)),
                ('related_client', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='request_aggregator.Chat2DeskClientEntry')),
            ],
            options={
                'db_table': 'chat2desk_messages',
            },
        ),
        migrations.CreateModel(
            name='Chat2DeskOperatorEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('related_id', models.IntegerField()),
                ('related_staff_work_phone', models.IntegerField(null=True)),
                ('print_name', models.CharField(blank=True, max_length=64)),
                ('phone', phonenumber_field.modelfields.PhoneNumberField(max_length=128, null=True)),
                ('email', models.CharField(max_length=64)),
                ('role', models.CharField(choices=[('admin', 'ADMIN'), ('deleted', 'DELETED'), ('disabled', 'DISABLED'), ('operator', 'OPERATOR'), ('supervisor', 'SUPERVISOR'), ('unconfirmed', 'UNCONFIRMED')], max_length=16)),
            ],
            options={
                'db_table': 'chat2desk_operators',
            },
        ),
        migrations.AddField(
            model_name='chat2deskmessageentry',
            name='related_operator',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='request_aggregator.Chat2DeskOperatorEntry'),
        ),
    ]
