# Generated by Django 2.0.3 on 2018-12-03 16:16

from django.db import migrations, models
import django.db.models.deletion
import phonenumber_field.modelfields


class Migration(migrations.Migration):

    dependencies = [
        ('callcenter', '0011_add_cc_stat_access'),
        ('request_aggregator', '0020_alter_original_phone_field'),
    ]

    operations = [
        migrations.CreateModel(
            name='BeeperAgentEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('related_id', models.CharField(max_length=64)),
                ('related_name', models.CharField(max_length=128, null=True)),
                ('staff_entry_binding', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='callcenter.CallCenterStaffEntry')),
            ],
        ),
        migrations.CreateModel(
            name='BeeperCallEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('direction', models.CharField(choices=[('i', 'INCOMING'), ('o', 'OUTGOING')], max_length=1)),
                ('time_enter', models.DateTimeField()),
                ('time_connect', models.DateTimeField(null=True)),
                ('time_exit', models.DateTimeField()),
                ('is_answered', models.BooleanField()),
                ('duration', models.PositiveIntegerField(null=True)),
                ('phone', phonenumber_field.modelfields.PhoneNumberField(max_length=128)),
                ('internal_call_id', models.CharField(max_length=64)),
                ('beeper_agent_entry_binding', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='request_aggregator.BeeperAgentEntry')),
                ('user_binding', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='request_aggregator.RequestUserPhoneBindingEntry')),
            ],
            options={
                'db_table': 'beeper_call_stats',
            },
        ),
        migrations.AddIndex(
            model_name='beepercallentry',
            index=models.Index(fields=['time_enter'], name='cc_beeper_time_enter_idx'),
        ),
        migrations.AddIndex(
            model_name='beepercallentry',
            index=models.Index(fields=['phone'], name='cc_beeper_phone_idx'),
        ),
    ]
