# Generated by Django 2.0.3 on 2019-02-03 17:14

from django.conf import settings
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import phonenumber_field.modelfields
import uuid


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('request_aggregator', '0029_alter_beeper_call_id_and_track'),
    ]

    operations = [
        migrations.CreateModel(
            name='CallTagCategory',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('request', models.TextField()),
                ('result', models.TextField()),
                ('tag_origin', models.TextField(choices=[('ai', 'AUDIOTELE_INCOMING'), ('ao', 'AUDIOTELE_OUTGOING'), ('ii', 'CARSHARING'), ('iiv', 'CARSHARING_VIP'), ('io', 'CARSHARING_OUTGOING')])),
            ],
            options={
                'db_table': 'call_tag_category',
            },
        ),
        migrations.CreateModel(
            name='RequestTagEntry',
            fields=[
                ('entry_id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('submitted_at', models.DateTimeField()),
                ('tag_id', models.UUIDField()),
                ('tag_type', models.TextField()),
                ('request_id', models.TextField(null=True)),
                ('request_origin', models.TextField()),
                ('original_phone', phonenumber_field.modelfields.PhoneNumberField(max_length=128, null=True)),
                ('original_user_id', models.UUIDField(null=True)),
                ('related_phone', phonenumber_field.modelfields.PhoneNumberField(max_length=128, null=True)),
                ('related_user_id', models.UUIDField(null=True)),
                ('comment', models.TextField()),
                ('meta_info', django.contrib.postgres.fields.jsonb.JSONField(null=True)),
                ('performer', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'request_tag',
            },
        ),
    ]
