# Generated by Django 2.0.3 on 2019-04-08 16:51

from django.conf import settings
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import phonenumber_field.modelfields


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('request_aggregator', '0040_provide_audiotele_call_action'),
    ]

    operations = [
        migrations.CreateModel(
            name='RequestTagEntryHistory',
            fields=[
                ('history_event_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_timestamp', models.IntegerField()),
                ('history_action', models.TextField()),
                ('entry_id', models.UUIDField()),
                ('submitted_at', models.DateTimeField()),
                ('tag_id', models.UUIDField()),
                ('tag_type', models.TextField()),
                ('request_id', models.TextField(null=True)),
                ('request_origin', models.TextField()),
                ('original_phone', phonenumber_field.modelfields.PhoneNumberField(max_length=128, null=True)),
                ('original_user_id', models.UUIDField(null=True)),
                ('related_phone', phonenumber_field.modelfields.PhoneNumberField(max_length=128, null=True)),
                ('related_user_id', models.UUIDField(null=True)),
                ('comment', models.TextField()),
                ('meta_info', django.contrib.postgres.fields.jsonb.JSONField(null=True)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='request_tag_history_history_user_id', to=settings.AUTH_USER_MODEL)),
                ('performer', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='request_tag_history_performer_id', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'request_tag_history',
            },
        ),
    ]
