# Generated by Django 2.0.3 on 2019-04-25 08:23

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import phonenumber_field.modelfields


class Migration(migrations.Migration):

    dependencies = [
        ('callcenter', '0017_add_reported_at_time'),
        ('request_aggregator', '0042_alter_call_tags'),
    ]

    operations = [
        migrations.CreateModel(
            name='CallCenterAltayOutgoingEntry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('external_id', models.IntegerField()),
                ('status', models.TextField()),
                ('noc_status', models.TextField(null=True)),
                ('time_enter', models.DateTimeField()),
                ('time_connect', models.DateTimeField(null=True)),
                ('time_exit', models.DateTimeField()),
                ('duration', models.PositiveIntegerField(null=True)),
                ('wait_duration', models.PositiveIntegerField(null=True)),
                ('call_type', models.CharField(choices=[('f', 'formal_from_yandex'), ('i', 'informal_from_customer')], max_length=1, null=True)),
                ('comment', models.TextField(default='')),
                ('phone', phonenumber_field.modelfields.PhoneNumberField(max_length=128, null=True)),
                ('has_record', models.BooleanField()),
                ('meta_info', django.contrib.postgres.fields.jsonb.JSONField(null=True)),
                ('staff_entry_binding', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='callcenter.CallCenterStaffEntry')),
            ],
            options={
                'db_table': 'call_center_altay_outgoing_stats',
            },
        ),
        migrations.AddIndex(
            model_name='callcenteraltayoutgoingentry',
            index=models.Index(fields=['external_id'], name='cc_internal_altay_out_external_id_idx'),
        ),
        migrations.AddIndex(
            model_name='callcenteraltayoutgoingentry',
            index=models.Index(fields=['time_enter'], name='cc_internal_altay_out_time_enter_idx'),
        ),
        migrations.AddIndex(
            model_name='callcenteraltayoutgoingentry',
            index=models.Index(fields=['phone'], name='cc_internal_altay_out_phone_idx'),
        ),
    ]
