import logging
import os
import sys


def setup():
    sys.path.append('../')
    sys.path.append('../../')
    sys.path.append('../../../')

    import django
    os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'cars.django.settings')
    django.setup()


if __name__ == '__main__':
    setup()


from cars.request_aggregator.core.ftp_helper import SFTPFileDownloader, SFTPDownloadFileManager
from cars.request_aggregator.core.beeper import BeeperMDSHelper
from cars.request_aggregator.models import BeeperCallTrackEntry
from cars.settings import REQUEST_AGGREGATOR as request_aggregator_settings


LOGGER = logging.getLogger(__name__)
LOGGER.addHandler(logging.StreamHandler())
LOGGER.addHandler(logging.FileHandler('./log.log'))


class BeeperFileDownloader(SFTPFileDownloader):
    @classmethod
    def from_settings(cls, root_dir):
        beeper_ftp_connection_settings = request_aggregator_settings['beeper']['ftp_connection']
        return cls(root_dir=root_dir, **beeper_ftp_connection_settings)


class BeeperCallTrackManager(SFTPDownloadFileManager):
    def __init__(self, root_dir):
        super(BeeperCallTrackManager).__init__(
            root_dir, BeeperFileDownloader, BeeperMDSHelper,
            progress_tick_interval=100
        )

    def _filter_entry(self, track_entry):
        return not BeeperCallTrackEntry.objects.filter(file_name=track_entry.file_name).exists()

    def _make_track_entry(self, file_description):
        track_entry = BeeperCallTrackEntry(
            file_name=file_description.filename,
            file_attrs={
                'size': file_description.st_size,
                'mtime': file_description.st_mtime,
                # 'to_remove': False,
            },
        )
        return track_entry


if __name__ == '__main__':
    actual_root_directories = ['Conversion/new/395187', 'Conversion/new/34019', 'Conversion/new/34018']
    mgr = BeeperCallTrackManager(None)
    mgr.process()
