from django.conf.urls import url

from . import views


app_name = 'request_aggregator'
urlpatterns = [
    url(
        r'^aggregated/requests/$',
        views.AggregatedEntriesAPIView.as_view(),
        name='aggregated-requests'
    ),
    url(
        r'^chat2desk/web_hook/$',
        views.Chat2DeskWebHookAPIView.as_view(),  # specific external auth
        name='chat2desk-webhook'
    ),
    url(
        r'^chat2desk/messages/$',
        views.Chat2DeskMessagesAPIView.as_view(),
        name='chat2desk-messages'
    ),
    url(
        r'^audiotele/webhook/start_calls/$',
        views.AudioteleStartCallsWebHookAPIView.as_view(),  # specific external auth
        name='audiotele-webhook-start-calls'
    ),
    url(
        r'^audiotele/webhook/finish_calls/$',
        views.AudioteleFinishCallsWebHookAPIView.as_view(),  # specific external auth
        name='audiotele-webhook-finish-calls'
    ),
    url(
        r'^audiotele/tracks/$',
        views.AudioteleCallTrackAPIView.as_view(),
        name='audiotele-tracks'
    ),
    url(
        r'^beeper/tracks/$',
        views.BeeperCallTrackAPIView.as_view(),
        name='beeper-tracks'
    ),
    url(
        r'^nextcontact/webhook/start_calls/?$',
        views.NextContactStartCallsWebHookAPIView.as_view(),  # specific external auth
        name='nextcontact-webhook-start-calls'
    ),
    url(
        r'^nextcontact/webhook/finish_calls/?$',
        views.NextContactFinishCallsWebHookAPIView.as_view(),  # specific external auth
        name='nextcontact-webhook-finish-calls'
    ),
    url(
        r'^tags/$',
        views.RequestTagView.as_view(),
        name='request-tag'
    ),
    url(
        r'^tags/origins/$',
        views.RequestOriginView.as_view(),
        name='request-tag-origins'
    ),
    url(
        r'^tags/categories/$',
        views.RequestTagCategoryView.as_view(),
        name='request-tag-categories'
    ),
    url(
        r'^tags/assign/$',
        views.RequestTagAssignmentView.as_view(),
        name='request-tag-assign'
    ),
    url(
        r'^tags/remove/$',
        views.RequestTagRemovalView.as_view(),
        name='request-tag-remove'
    ),
]
