import logging

from rest_framework.response import Response
from rest_framework.status import HTTP_400_BAD_REQUEST

from cars.core.authorization import (
    ExternalAuthenticationFactory, ExternalAuthenticationAPIView,
    DriveRolePermissionFactory, DriveActionPermissionFactory,
)
from cars.settings import REQUEST_AGGREGATOR as settings

from ..core import AudioteleWebHookHelper, AudioteleProcessingHelper

from .base import CallTrackAPIView

LOGGER = logging.getLogger(__name__)


class AudioteleWebHookAPIView(ExternalAuthenticationAPIView):
    authentication_classes = [
        ExternalAuthenticationFactory.build(
            token=settings['audiotele']['robot_auth_token'],
            salt=settings['audiotele']['token_salt'],
        )
    ]

    _helper = AudioteleWebHookHelper.from_settings()

    def handle_errors(self, error_message):
        LOGGER.error(error_message)
        return Response(error_message, status=HTTP_400_BAD_REQUEST)


class AudioteleStartCallsWebHookAPIView(AudioteleWebHookAPIView):
    def do_post(self, request):
        try:
            self._helper.process_call_start(request.data)
        except Exception as exc:
            return self.handle_errors(str(exc))

        return Response()


class AudioteleFinishCallsWebHookAPIView(AudioteleWebHookAPIView):
    def do_post(self, request):
        try:
            self._helper.process_call_finish(request.data)
        except Exception as exc:
            return self.handle_errors(str(exc))

        return Response()


class AudioteleCallTrackAPIView(CallTrackAPIView):
    helper = AudioteleProcessingHelper.from_settings()
