import logging

from rest_framework.response import Response
from rest_framework.status import HTTP_400_BAD_REQUEST

from cars.core.authorization import (
    ExternalAuthenticationFactory, ExternalAuthenticationAPIView,
)
from cars.settings import REQUEST_AGGREGATOR as settings

from ..core.nextcontact import NextContactWebHookHelper

LOGGER = logging.getLogger(__name__)


class NextContactWebHookAPIView(ExternalAuthenticationAPIView):
    authentication_classes = [
        ExternalAuthenticationFactory.build(
            token=settings['nextcontact']['robot_auth_token'],
            salt=settings['nextcontact']['token_salt'],
        )
    ]

    _helper = NextContactWebHookHelper.from_settings()

    def handle_errors(self, error_message):
        LOGGER.error(error_message)
        return Response(error_message, status=HTTP_400_BAD_REQUEST)


class NextContactStartCallsWebHookAPIView(NextContactWebHookAPIView):
    def do_post(self, request):
        try:
            self._helper.process_call_start(request.data)
        except Exception as exc:
            return self.handle_errors(str(exc))

        return Response()


class NextContactFinishCallsWebHookAPIView(NextContactWebHookAPIView):
    def do_post(self, request):
        try:
            self._helper.process_call_finish(request.data)
        except Exception as exc:
            return self.handle_errors(str(exc))

        return Response()
