# Generated by Django 2.0.3 on 2018-12-13 12:50

from django.db import migrations, models

import cars.settings


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='DriveCarDocumentAssignmentHistory',
            fields=[
                ('history_event_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_user_id', models.UUIDField()),
                ('history_action', models.TextField()),
                ('history_timestamp', models.IntegerField()),
                ('history_comment', models.TextField(blank=True, null=True)),
                ('history_originator_id', models.TextField(blank=True, null=True)),
                ('id', models.UUIDField()),
                ('assigned_at', models.DateTimeField(blank=True, null=True)),
                ('unassigned_at', models.DateTimeField(blank=True, null=True)),
                ('assigned_by_id', models.UUIDField(blank=True, null=True)),
                ('car_id', models.UUIDField()),
                ('document_id', models.UUIDField()),
                ('unassigned_by_id', models.UUIDField(blank=True, null=True)),
            ],
            options={
                'db_table': 'drive_car_document_assignment_history',
                'managed': cars.settings.IS_TESTS,
            },
        ),
        migrations.CreateModel(
            name='DriveCarDocumentHistory',
            fields=[
                ('history_event_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_user_id', models.UUIDField()),
                ('history_action', models.TextField()),
                ('history_timestamp', models.IntegerField()),
                ('history_comment', models.TextField(blank=True, null=True)),
                ('history_originator_id', models.TextField(blank=True, null=True)),
                ('id', models.UUIDField()),
                ('type', models.CharField(max_length=32)),
                ('added_at', models.DateTimeField()),
                ('added_by_id', models.UUIDField(blank=True, null=True)),
                ('car_hardware_beacon_id', models.UUIDField(blank=True, null=True)),
                ('car_hardware_sim_id', models.UUIDField(blank=True, null=True)),
                ('car_hardware_vega_id', models.UUIDField(blank=True, null=True)),
                ('car_hardware_head_id', models.UUIDField(blank=True, null=True)),
                ('car_hardware_modem_id', models.UUIDField(blank=True, null=True)),
                ('car_registry_document_id', models.UUIDField(blank=True, null=True)),
                ('car_insurance_policy_id', models.IntegerField(blank=True, null=True)),
                ('blob', models.CharField(blank=True, max_length=8192, null=True)),
                ('modified_at', models.DateTimeField()),
            ],
            options={
                'db_table': 'drive_car_document_history',
                'managed': cars.settings.IS_TESTS,
            },
        ),
    ]
