from django.db import models


class DriveCarDocumentAssignmentHistory(models.Model):
    history_event_id = models.AutoField(primary_key=True)
    history_user_id = models.UUIDField()
    history_action = models.TextField()
    history_timestamp = models.IntegerField()
    history_comment = models.TextField(blank=True, null=True)
    history_originator_id = models.TextField(blank=True, null=True)
    id = models.UUIDField()
    assigned_at = models.DateTimeField(blank=True, null=True)
    unassigned_at = models.DateTimeField(blank=True, null=True)
    assigned_by_id = models.UUIDField(blank=True, null=True)
    car_id = models.UUIDField()
    document_id = models.UUIDField()
    unassigned_by_id = models.UUIDField(blank=True, null=True)

    class Meta:
        managed = False
        db_table = 'drive_car_document_assignment_history'


class DriveCarDocumentHistory(models.Model):
    history_event_id = models.AutoField(primary_key=True)
    history_user_id = models.UUIDField()
    history_action = models.TextField()
    history_timestamp = models.IntegerField()
    history_comment = models.TextField(blank=True, null=True)
    history_originator_id = models.TextField(blank=True, null=True)
    id = models.UUIDField()
    type = models.CharField(max_length=32)
    added_at = models.DateTimeField()
    added_by_id = models.UUIDField(blank=True, null=True)
    car_hardware_beacon_id = models.UUIDField(blank=True, null=True)
    car_hardware_sim_id = models.UUIDField(blank=True, null=True)
    car_hardware_vega_id = models.UUIDField(blank=True, null=True)
    car_hardware_head_id = models.UUIDField(blank=True, null=True)
    car_hardware_modem_id = models.UUIDField(blank=True, null=True)
    car_registry_document_id = models.UUIDField(blank=True, null=True)
    car_insurance_policy_id = models.IntegerField(blank=True, null=True)
    blob = models.CharField(max_length=8192, blank=True, null=True)
    modified_at = models.DateTimeField()

    class Meta:
        managed = False
        db_table = 'drive_car_document_history'
