from rest_framework.serializers import BooleanField, ModelSerializer, CharField, IntegerField

from cars.carsharing.models.car_hardware import (
    CarHardwareBeacon,
    CarHardwareHead,
    CarHardwareModem,
    CarHardwareSim,
    CarHardwareVega,
)
from cars.django.serializers import BaseSerializer


class CarHardwareSimSerializer(ModelSerializer):

    class Meta:
        model = CarHardwareSim
        fields = '__all__'


class CarHardwareBeaconSerializer(ModelSerializer):

    sim = CarHardwareSimSerializer()

    class Meta:
        model = CarHardwareBeacon
        fields = '__all__'


class CarHardwareHeadSerializer(ModelSerializer):

    class Meta:
        model = CarHardwareHead
        fields = '__all__'


class CarHardwareModemSerializer(ModelSerializer):

    sim = CarHardwareSimSerializer()

    class Meta:
        model = CarHardwareModem
        fields = '__all__'


class CarHardwareVegaSerializer(ModelSerializer):

    primary_sim = CarHardwareSimSerializer()
    secondary_sim = CarHardwareSimSerializer()

    class Meta:
        model = CarHardwareVega
        fields = '__all__'


class UploadCarHardwareSimViewArgumentsSerializer(BaseSerializer):

    phone_number = CharField(required=True)
    icc = IntegerField(required=True)


class UploadCarHardwareBeaconViewArgumentsSerializer(BaseSerializer):

    imei = CharField(required=True)
    sim_icc = CharField(required=False)


class UploadCarHardwareVegaViewArgumentsSerializer(BaseSerializer):

    imei = IntegerField(required=True)
    primary_sim_icc = CharField(required=False)
    secondary_sim_icc = CharField(required=False)


class CarHardwareAttachToCarViewArgumentsSerializer(BaseSerializer):

    device_code = CharField(required=True)
    force = BooleanField(required=False)
