from rest_framework.serializers import BooleanField, ModelSerializer

from cars.carsharing.models import Car, CarLocation, CarModel
from cars.carsharing.models.car_telematics_state import CarTelematicsState
from cars.django.serializers import BaseSerializer


class ServiceAppCarLocationSerializer(ModelSerializer):

    class Meta:
        model = CarLocation
        fields = [
            'lat',
            'lon',
        ]


class ServiceAppCarModelSerializer(ModelSerializer):

    class Meta:
        model = CarModel
        fields = [
            'code',
            'manufacturer',
            'name',
            'video_url',
            'image_large_url',
            'image_small_url',
        ]


class ServiceAppCarTelematicsStateSerializer(ModelSerializer):

    class Meta:
        model = CarTelematicsState
        fields = [
            'fuel_level',
            'front_left_door_open',
            'front_right_door_open',
            'rear_left_door_open',
            'rear_right_door_open',
        ]


class ServiceAppCarSerializer(ModelSerializer):

    model = ServiceAppCarModelSerializer()
    location = ServiceAppCarLocationSerializer()
    telematics_state = ServiceAppCarTelematicsStateSerializer()

    class Meta:
        model = Car
        fields = [
            'id',
            'number',
            'model',
            'vin',
            'status',
            'location',
            'telematics_state',
            'fuel_card_number',
            'responsible_picker',
        ]


class ServiceAppCarActionArgumentsSerializer(BaseSerializer):

    check_telematics = BooleanField(required=False)
